
#ifndef _1_CRYS_Ext_ATP_ECC_Acceptance_h_H
#define _1_CRYS_Ext_ATP_ECC_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"

#if TST_USE_ECC_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Jan 12 12:18:08 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_ECC_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs  ****************************/
/************************ Structs  ******************************/
typedef struct TST_ExtApp_ECC_SignVerifyTestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    CRYS_ECPKI_DomainID_t		TST_CRYS_ECPKI_DomainID;
    CRYS_ECPKI_HASH_OpMode_t    TST_HashMode;
    DxUint8_t 					TST_input_data[TST_MAX_DATA_VEC_SIZE_IN_BYTS];	
    DxUint32_t                  TST_input_dataSize;
    DxUint8_t                   TST_ExternalPublKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPublKeySize;
    DxUint8_t                   TST_ExternalPrivKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPrivKeySize;
    DxUint8_t                   TST_output_signiture[TST_ECC_DATA_VEC_SIZE_IN_BYTS];
    DxUint32_t                  TST_SignitureSize;
} TST_ExtApp_ECC_SignVerifyTestDataStruct;

typedef struct TST_ExtApp_ECC_DH_TestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    CRYS_ECPKI_DomainID_t		TST_CRYS_ECPKI_DomainID;
    DxUint8_t                   TST_ExternalPublKey1[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPublKey1Size;
    DxUint8_t                   TST_ExternalPrivKey1[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPrivKey1Size;
    DxUint8_t                   TST_ExternalPublKey2[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPublKey2Size;
    DxUint8_t                   TST_ExternalPrivKey2[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPrivKey2Size;
} TST_ExtApp_ECC_DH_TestDataStruct;

typedef struct TST_ExtApp_ECC_EncDecTestDataStruct{	
    char					    TST_Name[TST_NAME_STRING_LEN];
    CRYS_ECPKI_DomainID_t		TST_CRYS_ECPKI_DomainID;
    DxUint8_t 					TST_input_data[TST_ECC_DATA_VEC_SIZE_IN_BYTS];	
    DxUint32_t                  TST_input_dataSize;
    DxUint8_t                   TST_ExternalPublKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPublKeySize;
    DxUint8_t                   TST_ExternalPrivKey[TST_MAX_ECC_KEY_SIZE_BYTES];
    DxUint32_t                  TST_ExternalPrivKeySize;
    DxUint8_t                   TST_output_data[TST_ECC_DATA_VEC_SIZE_IN_BYTS];
    DxUint32_t                  TST_output_dataSize;
    DxUint8_t                   TST_Decrypted_data[TST_ECC_DATA_VEC_SIZE_IN_BYTS];
    DxUint32_t                  TST_Decrypted_dataSize;
} TST_ExtApp_ECC_EncDecTestDataStruct;

/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_ECC_ECDSA_NonIntegratedSignVerify      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for ECC ESDSA Sign & Verify function,
*  implemented as external SEP application  
* Algorithm:       
* 1. Call the SEPQA_ECC_ECDSA_NonIntegratedSignVerify function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_ExtApp_ATP_ECC_ECDSA_NonIntegratedSignVerify  ( int TST_KeyGeneration_TestStatus );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_ECC_ECDSA_IntegratedSignVerify      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for ECC ESDSA Sign & Verify,
*  implemented as external SEP application  
* Algorithm:       
* 1. Call the SEPQA_ECC_ECDSA_NonIntegratedSignVerify function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_ExtApp_ATP_ECC_ECDSA_IntegratedSignVerify  ( int TST_KeyGeneration_TestStatus );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_ECC_DH      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for Diffie-Hellman key shared secret generation using ECC capabilities,
*  implemented as external SEP application  
* Algorithm:       
* 1. Call the SEPQA_ECC_DH function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_ExtApp_ATP_ECC_DH  (int TST_KeyGeneration_TestStatus);

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_ECC_ElGamal_EncDec      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for El-Gamal algorithm for encryption and decryption
*  implemented as external SEP application  
* Algorithm:       
* 1. Call the SEPQA_ECC_ElGamal_EncDec function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_ExtApp_ATP_ECC_ElGamal_EncDec  ( int TST_KeyGeneration_TestStatus );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_ECC_ImportExportKeyPair      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for ECC export public key functionality,
*  implemented as external SEP application  
* Algorithm:       
* 1. Call the SEPQA_ECC_ImportExportKeyPair function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_ExtApp_ATP_ECC_ImportExportKeyPair  ( int TST_KeyGeneration_TestStatus);

#ifdef __cplusplus
}
#endif

#endif

#endif




